/*
   mkvmerge -- utility for splicing together matroska files
   from component media subtypes

   Distributed under the GPL
   see the file COPYING for details
   or visit http://www.gnu.org/copyleft/gpl.html

   $Id: p_pcm.h 2809 2005-02-24 21:05:35Z mosu $

   class definition for the PCM output module

   Written by Moritz Bunkus <moritz@bunkus.org>.
*/

#ifndef __P_PCM_H
#define __P_PCM_H

#include "os.h"

#include "byte_buffer.h"
#include "common.h"
#include "pr_generic.h"

class pcm_packetizer_c: public generic_packetizer_c {
private:
  int packetno, bps, samples_per_sec, channels, bits_per_sample, packet_size;
  int64_t bytes_output, skip_bytes;
  bool big_endian;
  byte_buffer_c buffer;

public:
  pcm_packetizer_c(generic_reader_c *_reader, int _samples_per_sec,
                   int _channels, int _bits_per_sample, track_info_c &_ti,
                   bool _big_endian = false)
    throw (error_c);
  virtual ~pcm_packetizer_c();

  virtual int process(memory_c &mem, int64_t timecode = -1,
                      int64_t length = -1, int64_t bref = -1,
                      int64_t fref = -1);
  virtual void set_headers();
  virtual void flush();

  virtual void dump_debug_info();

  virtual const char *get_format_name() {
    return "PCM";
  }
  virtual connection_result_e can_connect_to(generic_packetizer_c *src);
};

#endif // __P_PCM_H
