/*
  mkvmerge -- utility for splicing together matroska files
      from component media subtypes

  p_mp3.h

  Written by Moritz Bunkus <moritz@bunkus.org>

  Distributed under the GPL
  see the file COPYING for details
  or visit http://www.gnu.org/copyleft/gpl.html
*/

/*!
    \file
    \version $Id: p_mp3.h 1328 2003-12-12 14:21:27Z mosu $
    \brief class definition for the MP3 output module
    \author Moritz Bunkus <moritz@bunkus.org>
*/

#ifndef __P_MP3_H
#define __P_MP3_H

#include "os.h"

#include "byte_buffer.h"
#include "common.h"
#include "pr_generic.h"
#include "mp3_common.h"

class mp3_packetizer_c: public generic_packetizer_c {
private:
  int64_t bytes_output, packetno;
  unsigned long samples_per_sec;
  int channels, spf;
  byte_buffer_c byte_buffer;
  bool codec_id_set;

public:
  mp3_packetizer_c(generic_reader_c *nreader, unsigned long nsamples_per_sec,
                   int nchannels, track_info_c *nti)
    throw (error_c);
  virtual ~mp3_packetizer_c();

  virtual int process(unsigned char *buf, int size, int64_t timecode = -1,
                      int64_t length = -1, int64_t bref = -1,
                      int64_t fref = -1);
  virtual void set_headers();

private:
  virtual unsigned char *get_mp3_packet(mp3_header_t *mp3header);

  virtual void dump_debug_info();
};

#endif // __P_MP3_H
